package gov.va.med.mhv.usermgmt.essapi.transfer;

import gov.va.med.mhv.common.api.enumeration.CountryEnum;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.enumeration.StateEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.common.data.converter.UserProfileConverter;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.core.validate.EmailValidator;
import gov.va.med.mhv.usermgmt.common.enums.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.Gender;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;

import java.util.Date;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProfileAPIConverter {

	@Autowired
	private UserProfileConverter converter;
	
	public UserProfile convertDomainProfile(UserProfile domainObject, RegisterTO registerTO, HashMap<String, Object> patientInfoMap) {

		boolean checkCity = 	isCheckNullOrEmpty(registerTO.getCity());
		boolean checkCountry = 	isCheckNullOrEmpty(registerTO.getCountry());
		boolean checkZip =		isCheckNullOrEmpty(registerTO.getZip());
		boolean checkaddr =		isCheckNullOrEmpty(registerTO.getAddress1());
		
		MHVException mhvException = new MHVException();
		
		StringBuffer errorBuff = new StringBuffer();

		if(checkCity)
			errorBuff.append("City");
		if(checkCountry)
			errorBuff.append(" Country");
		if(checkZip)
			errorBuff.append(" Zip");
		if(checkaddr)
			errorBuff.append(" Address");
		
		
		
//		if (checkCity || checkCountry || checkZip || checkaddr)	 {
//			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.USER_REGISTRATION_INVALID_INPUT, new MHVException(errorBuff.append(" Required").toString()));
//		}
//		
//		if(isCheckNullOrEmpty(registerTO.getState()) && isCheckNullOrEmpty(registerTO.getProvince()) )
//			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.USER_REGISTRATION_INVALID_INPUT, new MHVException("State/Province is required"));
//		
		//Set First name & Last Name
		domainObject.setFirstName((String)patientInfoMap.get(MviConstants.FIRST_NAME));
		domainObject.setLastName((String)patientInfoMap.get(MviConstants.LAST_NAME));
		
		//Set Birth Date
		domainObject.setBirthDate((Date)patientInfoMap.get(MviConstants.BIRTH_DAY));
		
		//Set SSN
		domainObject.setSsn((String)patientInfoMap.get(MviConstants.SSN));
		
		//Set Gender
			Gender gender = (Gender)patientInfoMap.get(MviConstants.GENDER);
			domainObject.setGender(gender.getName());
			
		
		//Set Contact Preference
		if(registerTO.getContactMethod() == null) {
			registerTO.setContactMethod(ContactMethodEnumeration.Email.name());
			if (!isValidEmail(registerTO.getEmail()))
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
			else if(!gov.va.med.mhv.core.validate.EmailValidator.isValid(registerTO.getEmail() ) ) {
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);	
			}
		}
		
		domainObject.setContactInfoContactMethod(registerTO.getContactMethod());	
	
			switch (ContactMethodEnumeration.valueOf((registerTO.getContactMethod()))) {
				case Email: 
					if (!isValidEmail(registerTO.getEmail()))
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					else	
						domainObject.setContactInfoEmail(registerTO.getEmail());
					break;
				case Fax:
					if(registerTO.getFax() != null && !registerTO.getFax().trim().isEmpty())
						domainObject.setContactInfoFax((registerTO.getFax()));
					else
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					break;
				case HomePhone:
					if(registerTO.getHomePhone() != null && !registerTO.getHomePhone().trim().isEmpty())
						domainObject.setContactInfoHomePhone(registerTO.getHomePhone());
					else
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					break;
				case MobilePhone:
					if(registerTO.getMobilePhone() != null && !registerTO.getMobilePhone().trim().isEmpty())
						domainObject.setContactInfoMobilePhone(registerTO.getMobilePhone());
					else
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					break;
				case Pager:
					if(registerTO.getPager() != null && !registerTO.getPager().trim().isEmpty())
						domainObject.setContactInfoPager(registerTO.getPager());
					else
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					break;
				case WorkPhone:
					if(registerTO.getWorkPhone() != null && !registerTO.getWorkPhone().trim().isEmpty())
						domainObject.setContactInfoWorkPhone(registerTO.getWorkPhone());
					else
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					break;
					
				default:
					if (!isValidEmail(registerTO.getEmail()))
						MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
					else
						domainObject.setContactInfoEmail(registerTO.getEmail());
					break;
			}
		
		
		//set UserName
//		if (domainObject.getUserName() == null)
//			domainObject.setUserName(RandomUserNameGenerator.userNameGenerate(registerTO.getFirstName(), registerTO.getLastName(), registerTO.getBirthDate()));
//		
			domainObject.setCreatedDate(new Date(System.currentTimeMillis()));
			converter.generateMhvId(domainObject);	
		
		//set Disclaimer and Terms
		domainObject.setAcceptDisclaimer(true);
		domainObject.setAcceptTerms(true);
		//TODO: T&C Entries
		
		//set SM Terms, Rx and SIPAccess (rx has been taken care of at trigger)
		domainObject.setAcceptSMTerms(true);
	//	domainObject.setRxAgreementSigned(true);
	//	domainObject.setRxAgreementDate(new Date(System.currentTimeMillis()));
		domainObject.setRestrictSIPAccess(false);
		
		//Set Privacy
		domainObject.setAcceptPrivacy(true);
		
		//Set Relationship VA
		domainObject.setIsPatient(registerTO.getIsPatient());
		domainObject.setIsChampVABeneficiary(registerTO.getIsChampVABeneficiary());
		domainObject.setIsEmployee(registerTO.getIsEmployee());
		domainObject.setIsHealthCareProvider(registerTO.getIsHealthCareProvider());
		domainObject.setIsOther(registerTO.getIsOther());
		domainObject.setIsPatientAdvocate(registerTO.getIsPatientAdvocate());
		domainObject.setIsServiceMember(registerTO.getIsServiceMemeber());
		domainObject.setIsVeteran(registerTO.getIsVeteran());
		
		if( isCheckNullOrFalse(domainObject.getIsPatient()) && isCheckNullOrFalse(domainObject.getIsChampVABeneficiary()) &&
			isCheckNullOrFalse(domainObject.getIsEmployee()) && isCheckNullOrFalse(domainObject.getIsHealthCareProvider()) &&
			isCheckNullOrFalse(domainObject.getIsOther()) && isCheckNullOrFalse(domainObject.getIsPatientAdvocate())	&&
			isCheckNullOrFalse(domainObject.getIsServiceMember()) && isCheckNullOrFalse(domainObject.getIsVeteran())
		) {
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.USER_REGISTRATION_INVALID_INPUT, new MHVException("Relationship is required"));
		}
		
		//set Address
		if(registerTO.getAddress1() != null)
			domainObject.setAddressStreet1(registerTO.getAddress1());
		if(registerTO.getAddress2() != null)
			domainObject.setAddressStreet2(registerTO.getAddress2());
		if(registerTO.getCity() != null)
			domainObject.setAddressCity(registerTO.getCity());
		if(registerTO.getCountry() != null)
			domainObject.setAddressCountry(CountryEnum.valueOfAbbreviation(registerTO.getCountry()).getCountryDetailName());
		if(registerTO.getZip() != null)
			domainObject.setAddressPostalCode(registerTO.getZip());
		
//		if (registerTO.getCountry().equalsIgnoreCase(CountryEnumeration.UNITED_STATES.getDescription())) {
//			domainObject.setAddressState(StateEnumeration.valueOf(registerTO.getState()).getDescription());
//			if (domainObject.getAddressState() == null)
//				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
//		}

		if(registerTO.getState() != null)
			domainObject.setAddressState(StateEnum.valueOfAbbreviation(registerTO.getState()).getStateCode());
		if (domainObject.getAddressProvince() != null)
			domainObject.setAddressProvince(registerTO.getProvince());

		/*
		if (registerTO.getCountry().equalsIgnoreCase(CountryEnum.UNITED_STATES.getCountryCode())) {
			domainObject.setAddressState(StateEnum.valueOfAbbreviation(registerTO.getState()).getStateCode());
			if (domainObject.getAddressState() == null)
				MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.USER_REGISTRATION_INVALID_INPUT, new MHVException("State is required"));
		}
		else {
			domainObject.setAddressProvince(registerTO.getProvince());
			if (domainObject.getAddressProvince() == null)
				MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.USER_REGISTRATION_INVALID_INPUT, new MHVException("Province is required"));
		}
		*/
		
		//setting Oplock because its not version.. God knows WHY..
	//	domainObject.setOplock(1);
		
		return domainObject;
		
	}
	
	private boolean isCheckNullOrEmpty(String objStr) {
		if(objStr == null || objStr.trim().isEmpty()) {
			return true;
		}
		else {
			return false;
		}
		
	}
	private boolean isCheckNullOrFalse(Boolean objBool) {
		if(objBool == null || !objBool.booleanValue()) {
			return true;
		}
		else {
			return false;
		}
		
	}	
	private boolean isValidEmail(String email) {
		return EmailValidator.isValid(email);
		
	}
	
}
